/*
 * Decompiled with CFR 0.152.
 */
package leviathan143.loottweaker.common.lib;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import leviathan143.loottweaker.common.darkmagic.LootEntryAccessors;
import leviathan143.loottweaker.common.lib.LootConditions;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootEntryEmpty;
import net.minecraft.world.storage.loot.LootEntryItem;
import net.minecraft.world.storage.loot.LootEntryTable;
import net.minecraft.world.storage.loot.conditions.LootCondition;

public class RobustLootEntrySerialiser
implements JsonSerializer<LootEntry> {
    private final JsonSerializer<LootEntry> vanilla = new LootEntry.Serializer();

    public JsonElement serialize(LootEntry value, Type type, JsonSerializationContext context) {
        if (value instanceof LootEntryItem || value instanceof LootEntryTable || value instanceof LootEntryEmpty) {
            return this.vanilla.serialize((Object)this.patch(value), type, context);
        }
        JsonObject json = new JsonObject();
        if (value.getEntryName() != null) {
            json.addProperty("entryName", value.getEntryName());
        }
        json.addProperty("weight", (Number)LootEntryAccessors.getWeight(value));
        json.addProperty("quality", (Number)LootEntryAccessors.getQuality(value));
        json.addProperty("type", "loottweaker:best_effort");
        LootCondition[] conditions = LootEntryAccessors.getConditions(value);
        if (conditions.length > 0) {
            json.add("conditions", context.serialize((Object)conditions));
        }
        json.addProperty("_comment", "A best effort serialisation of a non-serialisable entry");
        json.addProperty("class", value.getClass().getName());
        return json;
    }

    private LootEntry patch(LootEntry entry) {
        if (LootEntryAccessors.getConditionsUnsafe(entry) == null) {
            LootEntryAccessors.setConditions(entry, LootConditions.NONE);
        }
        return entry;
    }
}

